package org.retentionprediction;

import javax.help.HelpBroker;
import javax.help.HelpSet;

public class Globals
{
	public static HelpSet hsMainHelpSet = null;
	public static HelpBroker hbMainHelpBroker = null;
	
	public static double[][][] dTemperaturePrograms = {
		{ // HP 5890 5 min ramp
			{1, 50.0, 0, 30.0},
			{60, 5.0},
			{52, 320, 15}
		},
		{ // HP 5890 10 min ramp
			{1, 50.0, 0, 30.0},
			{60, 5.0},
			{26, 320, 15}
		},
		{ // HP 5890 20 min ramp
			{1, 50.0, 0, 30.0},
			{60, 5.0},
			{13, 320, 15}
		},
		{ // HP 5890 40 min ramp
			{1, 50.0, 0, 30.0},
			{60, 5.0},
			{6.5, 320, 15}
		},
		{ // HP 5890 5 min ramp stationary phase batch #2
			{1, 50.0, 0, 30.0},
			{60, 5.0},
			{52, 320, 15}
		},
		{ // HP 5890 10 min ramp stationary phase batch #2
			{1, 50.0, 0, 30.0},
			{60, 5.0},
			{26, 320, 15}
		},
		{ // HP 5890 20 min ramp stationary phase batch #2
			{1, 50.0, 0, 30.0},
			{60, 5.0},
			{13, 320, 15}
		},
		{ // HP 5890 40 min ramp stationary phase batch #2
			{1, 50.0, 0, 30.0},
			{60, 5.0},
			{6.5, 320, 15}
		},
		{ // HP 5890 5 min ramp stationary phase batch #3
			{1, 50.0, 0, 30.0},
			{60, 5.0},
			{52, 320, 15}
		},
		{ // HP 5890 10 min ramp stationary phase batch #3
			{1, 50.0, 0, 30.0},
			{60, 5.0},
			{26, 320, 15}
		},
		{ // HP 5890 20 min ramp stationary phase batch #3
			{1, 50.0, 0, 30.0},
			{60, 5.0},
			{13, 320, 15}
		},
		{ // HP 5890 40 min ramp stationary phase batch #3
			{1, 50.0, 0, 30.0},
			{60, 5.0},
			{6.5, 320, 15}
		},
		{ // HP 5890 20 min ramp, 100 kPa
			{1, 100.0, 0, 30.0},
			{60, 5.0},
			{13, 320, 15}
		},
		{ // HP 5890 20 min ramp, 150 kPa
			{1, 150.0, 0, 30.0},
			{60, 5.0},
			{13, 320, 15}
		},
		{ // HP 5890 60 C for 5 min, 26 C/min to 190 C for 15 min, 26 C/min to 320 C for 15 min
			{1, 50.0, 0, 30.0},
			{60, 5.0},
			{26, 190, 15},
			{26, 320, 15}
		},
		{ // HP 5890 60 C for 5 min, 6.5 C/min to 190 C for 0 min, 26 C/min to 320 C for 15 min
			{1, 50.0, 0, 30.0},
			{60, 5.0},
			{6.5, 190, 0},
			{26, 320, 15}
		},
		{ // HP 5890 60 C for 5 min, 26 C/min to 150 C for 10 min, 26 C/min to 235 C for 10 min, 26 C/min to 320 C for 15 min
			{1, 50.0, 0, 30.0},
			{60, 5.0},
			{26, 150, 10},
			{26, 235, 10},
			{26, 320, 15}			
		},
		{ // HP 5890 drugs 52 C/min ramp
			{1, 50.0, 0, 30.0},
			{200, 5.0},
			{52, 320, 15}
		},
		{ // HP 5890 drugs 26 C/min ramp
			{1, 50.0, 0, 30.0},
			{200, 5.0},
			{26, 320, 15}
		},
		{ // HP 5890 drugs 13 C/min ramp
			{1, 50.0, 0, 30.0},
			{200, 5.0},
			{13, 320, 15}
		},
		{ // HP 5890 drugs 6.5 C/min ramp
			{1, 50.0, 0, 30.0},
			{200, 5.0},
			{6.5, 320, 15}
		},
		{ // Agilent 7890A 5 min ramp
			{1, 50.0, 0, 30.0},
			{60, 5.0},
			{52, 320, 15}
		},
		{ // Agilent 7890A 10 min ramp
			{1, 50.0, 0, 30.0},
			{60, 5.0},
			{26, 320, 15}
		},
		{ // Agilent 7890A 20 min ramp
			{1, 50.0, 0, 30.0},
			{60, 5.0},
			{13, 320, 15}
		},
		{ // Agilent 7890A 40 min ramp
			{1, 50.0, 0, 30.0},
			{60, 5.0},
			{6.5, 320, 15}
		},
		{ // Thermo Trace GC Ultra 5 min ramp
			{1, 50.0, 0, 30.0},
			{60, 5.0},
			{52, 320, 15}
		},
		{ // Thermo Trace GC Ultra 10 min ramp
			{1, 50.0, 0, 30.0},
			{60, 5.0},
			{26, 320, 15}
		},
		{ // Thermo Trace GC Ultra 20 min ramp
			{1, 50.0, 0, 30.0},
			{60, 5.0},
			{13, 320, 15}
		},
		{ // Thermo Trace GC Ultra 40 min ramp
			{1, 50.0, 0, 30.0},
			{60, 5.0},
			{6.5, 320, 15}
		},
		{ // Thermo Trace GC Ultra 5 min ramp, 1 mL/min
			{0, 1.0, 0, 30.0},
			{60, 5.0},
			{52, 320, 15}
		},
		{ // Thermo Trace GC Ultra 10 min ramp, 1 mL/min
			{0, 1.0, 0, 30.0},
			{60, 5.0},
			{26, 320, 15}			
		},
		{ // Thermo Trace GC Ultra 20 min ramp, 1 mL/min
			{0, 1.0, 0, 30.0},
			{60, 5.0},
			{13, 320, 15}
		},
		{ // Thermo Trace GC Ultra 40 min ramp, 1 mL/min
			{0, 1.0, 0, 30.0},
			{60, 5.0},
			{6.5, 320, 15}
		},
		{ // Thermo Trace GC Ultra 20 min ramp, 2 mL/min
			{0, 2.0, 0, 30.0},
			{60, 5.0},
			{13, 320, 15}
		},
		{ // Thermo Trace GC Ultra 20 min ramp, 3 mL/min
			{0, 3.0, 0, 30.0},
			{60, 5.0},
			{13, 320, 15}
		}
	};
	
	public static String[] strPredefinedValues = {
		"HP 5890 5 min at 60 \u00b0C, 52 \u00b0C/min ramp to 320 \u00b0C, 15 min hold, 50 kPa",
		"HP 5890 5 min at 60 \u00b0C, 26 \u00b0C/min ramp to 320 \u00b0C, 15 min hold, 50 kPa",
		"HP 5890 5 min at 60 \u00b0C, 13 \u00b0C/min ramp to 320 \u00b0C, 15 min hold, 50 kPa",
		"HP 5890 5 min at 60 \u00b0C, 6.5 \u00b0C/min ramp to 320 \u00b0C, 15 min hold, 50 kPa",
		"HP 5890 5 min at 60 \u00b0C, 52 \u00b0C/min ramp to 320 \u00b0C, 15 min hold, 50 kPa, stat phase batch 2",
		"HP 5890 5 min at 60 \u00b0C, 26 \u00b0C/min ramp to 320 \u00b0C, 15 min hold, 50 kPa, stat phase batch 2",
		"HP 5890 5 min at 60 \u00b0C, 13 \u00b0C/min ramp to 320 \u00b0C, 15 min hold, 50 kPa, stat phase batch 2",
		"HP 5890 5 min at 60 \u00b0C, 6.5 \u00b0C/min ramp to 320 \u00b0C, 15 min hold, 50 kPa, stat phase batch 2",
		"HP 5890 5 min at 60 \u00b0C, 52 \u00b0C/min ramp to 320 \u00b0C, 15 min hold, 50 kPa, stat phase batch 3",
		"HP 5890 5 min at 60 \u00b0C, 26 \u00b0C/min ramp to 320 \u00b0C, 15 min hold, 50 kPa, stat phase batch 3",
		"HP 5890 5 min at 60 \u00b0C, 13 \u00b0C/min ramp to 320 \u00b0C, 15 min hold, 50 kPa, stat phase batch 3",
		"HP 5890 5 min at 60 \u00b0C, 6.5 \u00b0C/min ramp to 320 \u00b0C, 15 min hold, 50 kPa, stat phase batch 3",
		"HP 5890 5 min at 60 \u00b0C, 13 \u00b0C/min ramp to 320 \u00b0C, 15 min hold, 100 kPa",
		"HP 5890 5 min at 60 \u00b0C, 13 \u00b0C/min ramp to 320 \u00b0C, 15 min hold, 150 kPa",
		"HP 5890 non-linear #1, 50 kPa",
		"HP 5890 non-linear #2, 50 kPa",
		"HP 5890 non-linear #3, 50 kPa",
		"HP 5890 drugs 5 min at 200 \u00b0C, 52 \u00b0C/min ramp to 320 \u00b0C, 15 min hold, 50 kPa",
		"HP 5890 drugs 5 min at 200 \u00b0C, 26 \u00b0C/min ramp to 320 \u00b0C, 15 min hold, 50 kPa",
		"HP 5890 drugs 5 min at 200 \u00b0C, 13 \u00b0C/min ramp to 320 \u00b0C, 15 min hold, 50 kPa",
		"HP 5890 drugs 5 min at 200 \u00b0C, 6.5 \u00b0C/min ramp to 320 \u00b0C, 15 min hold, 50 kPa",
		"Agilent 7890A 5 min at 60 \u00b0C, 52 \u00b0C/min ramp to 320 \u00b0C, 15 min hold, 50 kPa",
		"Agilent 7890A 5 min at 60 \u00b0C, 26 \u00b0C/min ramp to 320 \u00b0C, 15 min hold, 50 kPa",
		"Agilent 7890A 5 min at 60 \u00b0C, 13 \u00b0C/min ramp to 320 \u00b0C, 15 min hold, 50 kPa",
		"Agilent 7890A 5 min at 60 \u00b0C, 6.5 \u00b0C/min ramp to 320 \u00b0C, 15 min hold, 50 kPa",
		"Thermo Trace GC Ultra 5 min at 60 \u00b0C, 52 \u00b0C/min ramp to 320 \u00b0C, 15 min hold, 50 kPa",
		"Thermo Trace GC Ultra 5 min at 60 \u00b0C, 26 \u00b0C/min ramp to 320 \u00b0C, 15 min hold, 50 kPa",
		"Thermo Trace GC Ultra 5 min at 60 \u00b0C, 13 \u00b0C/min ramp to 320 \u00b0C, 15 min hold, 50 kPa",
		"Thermo Trace GC Ultra 5 min at 60 \u00b0C, 6.5 \u00b0C/min ramp to 320 \u00b0C, 15 min hold, 50 kPa",
		"Thermo Trace GC Ultra 5 min at 60 \u00b0C, 52 \u00b0C/min ramp to 320 \u00b0C, 15 min hold, 1 mL/min",
		"Thermo Trace GC Ultra 5 min at 60 \u00b0C, 26 \u00b0C/min ramp to 320 \u00b0C, 15 min hold, 1 mL/min",
		"Thermo Trace GC Ultra 5 min at 60 \u00b0C, 13 \u00b0C/min ramp to 320 \u00b0C, 15 min hold, 1 mL/min",
		"Thermo Trace GC Ultra 5 min at 60 \u00b0C, 6.5 \u00b0C/min ramp to 320 \u00b0C, 15 min hold, 1 mL/min",
		"Thermo Trace GC Ultra 5 min at 60 \u00b0C, 13 \u00b0C/min ramp to 320 \u00b0C, 15 min hold, 2 mL/min",
		"Thermo Trace GC Ultra 5 min at 60 \u00b0C, 13 \u00b0C/min ramp to 320 \u00b0C, 15 min hold, 3 mL/min",
	};
	
	public static double[][] dPredefinedValues = {
		{ // HP 5890 5 min ramp
			2.532,
			3.736,
			5.864,
			7.116,
			7.988,
			8.609,
			9.089,
			9.501,
			9.871,
			10.224,
			10.564,
			10.894,
			11.218,
			11.537,
			11.849,
			12.160,
			12.476,
			12.800,
			13.136,
			13.493,
			14.309,
			15.346,
			16.740,
			18.684,
			21.439
		},
		{ // HP 5890 10 min ramp
			2.533,
			3.741,
			6.036,
			7.708,
			8.900,
			9.809,
			10.553,
			11.197,
			11.779,
			12.317,
			12.819,
			13.291,
			13.739,
			14.164,
			14.569,
			14.956,
			15.329,
			15.705,
			16.085,
			16.476,
			17.343,
			18.414,
			19.831,
			21.783,
			24.541
		},
		{ // HP 5890 20 min ramp
			2.533,
			3.739,
			6.191,
			8.530,
			10.396,
			11.932,
			13.260,
			14.451,
			15.546,
			16.569,
			17.531,
			18.440,
			19.303,
			20.125,
			20.907,
			21.656,
			22.372,
			23.058,
			23.716,
			24.350,
			25.564,
			26.885,
			28.482,
			30.567,
			33.419
		},
		{ // HP 5890 40 min ramp
			2.532,
			3.736,
			6.307,
			9.506,
			12.518,
			15.224,
			17.675,
			19.931,
			22.031,
			24.006,
			25.867,
			27.635,
			29.314,
			30.915,
			32.444,
			33.904,
			35.303,
			36.644,
			37.933,
			39.172,
			41.515,
			43.700,
			45.772,
			48.153,
			51.221
		},
		{ // HP 5890 5 min ramp 50 kPa stationary phase batch 2
			2.659,
			3.950,
			6.021,
			7.248,
			8.108,
			8.719,
			9.189,
			9.589,
			9.950,
			10.289,
			10.619,
			10.938,
			11.252,
			11.560,
			11.862,
			12.171,
			12.482,
			12.803,
			13.138,
			13.498,
			14.331,
			15.407,
			16.863,
			18.904,
			21.804	
		},
		{ // HP 5890 10 min ramp 50 kPa stationary phase batch 2
			2.660,
			3.950,
			6.238,
			7.870,
			9.049,
			9.954,
			10.695,
			11.338,
			11.922,
			12.459,
			12.963,
			13.434,
			13.882,
			14.308,
			14.711,
			15.097,
			15.476,
			15.857,
			16.242,
			16.642,
			17.535,
			18.652,
			20.139,
			22.196,
			25.114
		},
		{ // HP 5890 20 min ramp 50 kPa stationary phase batch 2
			2.660,
			3.953,
			6.451,
			8.753,
			10.603,
			12.134,
			13.460,
			14.652,
			15.749,
			16.773,
			17.735,
			18.645,
			19.508,
			20.331,
			21.113,
			21.862,
			22.577,
			23.263,
			23.920,
			24.553,
			25.780,
			27.142,
			28.805,
			30.994,
			34.006
		},
		{ // HP 5890 40 min ramp 50 kPa stationary phase batch 2
			2.660,
			3.952,
			6.621,
			9.824,
			12.832,
			15.536,
			17.988,
			20.247,
			22.352,
			24.327,
			26.194,
			27.963,
			29.644,
			31.247,
			32.774,
			34.236,
			35.636,
			36.978,
			38.264,
			39.504,
			41.846,
			44.028,
			46.129,
			48.609,
			51.832
		},
		{ // HP 5890 5 min ramp 50 kPa stationary phase batch 2
			2.599,
			3.863,
			5.963,
			7.195,
			8.052,
			8.661,
			9.127,
			9.524,
			9.880,
			10.216,
			10.542,
			10.857,
			11.165,
			11.469,
			11.767,
			12.071,
			12.378,
			12.694,
			13.025,
			13.378,
			14.198,
			15.252,
			16.686,
			18.692,
			21.545
		},
		{ // HP 5890 10 min ramp 50 kPa stationary phase batch 2
			2.601,
			3.866,
			6.165,
			7.809,
			8.991,
			9.896,
			10.636,
			11.279,
			11.861,
			12.398,
			12.901,
			13.372,
			13.821,
			14.246,
			14.650,
			15.036,
			15.411,
			15.790,
			16.172,
			16.569,
			17.454,
			18.555,
			20.017,
			22.043,
			24.908
		},
		{ // HP 5890 20 min ramp 50 kPa stationary phase batch 2
			2.600,
			3.865,
			6.358,
			8.674,
			10.528,
			12.061,
			13.386,
			14.577,
			15.672,
			16.696,
			17.659,
			18.569,
			19.431,
			20.254,
			21.036,
			21.785,
			22.500,
			23.185,
			23.843,
			24.476,
			25.698,
			27.045,
			28.686,
			30.843,
			33.805
		},
		{ // HP 5890 40 min ramp 50 kPa stationary phase batch 2
			2.601,
			3.865,
			6.509,
			9.713,
			12.724,
			15.428,
			17.878,
			20.137,
			22.240,
			24.216,
			26.081,
			27.850,
			29.530,
			31.131,
			32.660,
			34.121,
			35.520,
			36.863,
			38.151,
			39.391,
			41.733,
			43.915,
			46.006,
			48.453,
			51.630
		},
		{ // HP 5890 20 min ramp 100 kPa
			0.000,
			2.800,
			4.856,
			7.505,
			9.459,
			11.018,
			12.348,
			13.534,
			14.621,
			15.633,
			16.587,
			17.487,
			18.343,
			19.159,
			19.938,
			20.683,
			21.395,
			22.077,
			22.733,
			23.364,
			24.557,
			25.705,
			27.026,
			28.697,
			30.940
		},
		{ // HP 5890 20 min ramp 150 kPa
			0.000,
			0.000,
			3.894,
			6.724,
			8.790,
			10.382,
			11.718,
			12.902,
			13.983,
			14.989,
			15.935,
			16.830,
			17.681,
			18.490,
			19.266,
			20.006,
			20.714,
			21.394,
			22.048,
			22.677,
			23.866,
			24.975,
			26.125,
			27.540,
			29.409
		},
		{ // HP 5890 non-linear ramp #1
			2.533,
			3.735,
			6.029,
			7.705,
			8.898,
			9.806,
			10.574,
			11.330,
			12.164,
			13.196,
			14.569,
			16.485,
			19.235,
			23.230,
			26.844,
			28.238,
			29.189,
			29.914,
			30.520,
			31.073,
			32.124,
			33.283,
			34.745,
			36.718,
			39.486
		},
		{ // HP 5890 non-linear ramp #2
			2.529,
			3.736,
			6.314,
			9.514,
			12.528,
			15.234,
			17.682,
			19.937,
			22.037,
			24.009,
			25.766,
			26.957,
			27.859,
			28.583,
			29.185,
			29.702,
			30.157,
			30.584,
			30.998,
			31.414,
			32.307,
			33.389,
			34.809,
			36.765,
			39.520
		},
		{ // HP 5890 non-linear ramp #3
			2.532,
			3.736,
			6.030,
			7.705,
			8.917,
			10.034,
			11.303,
			13.035,
			15.623,
			19.334,
			21.131,
			22.292,
			23.359,
			24.455,
			25.690,
			27.190,
			29.096,
			31.571,
			33.436,
			34.515,
			36.103,
			37.586,
			39.245,
			41.343,
			44.203
		},
		{ // HP 5890 drugs 52 C/min ramp
			0.000,
			0.000,
			0.000,
			0.000,
			0.000,
			0.000,
			2.561,
			2.838,
			3.242,
			3.828,
			4.681,
			5.676,
			6.445,
			7.119,
			7.703,
			8.204,
			8.656,
			9.069,
			9.462,
			9.853,
			10.696,
			11.737,
			13.122,
			15.048,
			17.783
		},
		{ // HP 5890 drugs 26 C/min ramp
			0.000,
			0.000,
			0.000,
			0.000,
			0.000,
			0.000,
			2.557,
			2.834,
			3.236,
			3.820,
			4.671,
			5.750,
			6.709,
			7.552,
			8.287,
			8.924,
			9.478,
			9.974,
			10.446,
			10.903,
			11.851,
			12.964,
			14.398,
			16.361,
			19.115
		},
		{ // HP 5890 drugs 13 C/min ramp
			0.000,
			0.000,
			0.000,
			0.000,
			0.000,
			0.000,
			2.555,
			2.830,
			3.230,
			3.812,
			4.658,
			5.798,
			6.992,
			8.149,
			9.227,
			10.211,
			11.111,
			11.933,
			12.691,
			13.395,
			14.692,
			16.050,
			17.661,
			19.750,
			22.602
		},
		{ // HP 5890 drugs 6.5 C/min ramp
			0.000,
			0.000,
			0.000,
			0.000,
			0.000,
			0.000,
			2.554,
			2.829,
			3.229,
			3.810,
			4.655,
			5.833,
			7.237,
			8.768,
			10.338,
			11.884,
			13.378,
			14.805,
			16.163,
			17.461,
			19.878,
			22.104,
			24.193,
			26.579,
			29.644
		},
		{ // Agilent 7890A 5 min ramp
			2.562,
			3.855,
			5.963,
			7.162,
			7.995,
			8.573,
			9.023,
			9.389,
			9.712,
			10.001,
			10.281,
			10.536,
			10.792,
			11.038,
			11.276,
			11.523,
			11.778,
			12.058,
			12.356,
			12.696,
			13.520,
			14.643,
			16.215,
			18.451,
			21.664
		},
		{ // Agilent 7890A 10 min ramp
			2.579,
			3.872,
			6.192,
			7.807,
			8.972,
			9.865,
			10.604,
			11.250,
			11.837,
			12.381,
			12.883,
			13.359,
			13.818,
			14.243,
			14.651,
			15.050,
			15.433,
			15.824,
			16.215,
			16.632,
			17.575,
			18.774,
			20.398,
			22.667,
			25.915
		},
		{ // Agilent 7890A 20 min ramp
			2.579,
			3.889,
			6.413,
			8.709,
			10.554,
			12.084,
			13.410,
			14.609,
			15.714,
			16.742,
			17.711,
			18.630,
			19.505,
			20.338,
			21.129,
			21.885,
			22.608,
			23.305,
			23.968,
			24.614,
			25.872,
			27.301,
			29.086,
			31.475,
			34.816
		},
		{ // Agilent 7890A 40 min ramp
			2.588,
			3.889,
			6.592,
			9.822,
			12.832,
			15.535,
			18.000,
			20.270,
			22.387,
			24.376,
			26.255,
			28.048,
			29.740,
			31.364,
			32.903,
			34.382,
			35.801,
			37.153,
			38.462,
			39.712,
			42.084,
			44.302,
			46.479,
			49.148,
			52.667
		},
		{ // Thermo Trace GC Ultra 5 min ramp
			2.696,
			4.084,
			6.055,
			7.179,
			7.959,
			8.517,
			8.945,
			9.306,
			9.623,
			9.915,
			10.190,
			10.447,
			10.696,
			10.936,
			11.177,
			11.426,
			11.683,
			11.958,
			12.267,
			12.619,
			13.494,
			14.730,
			16.515,
			19.175,
			23.174
		},
		{ // Thermo Trace GC Ultra 10 min ramp
			2.688,
			4.084,
			6.330,
			7.847,
			8.962,
			9.828,
			10.557,
			11.191,
			11.775,
			12.315,
			12.830,
			13.302,
			13.757,
			14.194,
			14.598,
			14.992,
			15.387,
			15.782,
			16.194,
			16.631,
			17.644,
			18.974,
			20.836,
			23.539,
			27.563
		},
		{ // Thermo Trace GC Ultra 20 min ramp
			2.696,
			4.084,
			6.620,
			8.823,
			10.615,
			12.115,
			13.426,
			14.627,
			15.733,
			16.762,
			17.740,
			18.658,
			19.542,
			20.374,
			21.172,
			21.935,
			22.665,
			23.368,
			24.037,
			24.689,
			26.002,
			27.547,
			29.572,
			32.404,
			36.531
		},
		{ // Thermo Trace GC Ultra 40 min ramp
			2.696,
			4.084,
			6.886,
			10.049,
			13.014,
			15.696,
			18.146,
			20.426,
			22.553,
			24.551,
			26.438,
			28.239,
			29.946,
			31.575,
			33.128,
			34.620,
			36.044,
			37.417,
			38.738,
			39.999,
			42.409,
			44.666,
			47.051,
			50.140,
			54.482
		},
		{ // Thermo Trace GC Ultra 5 min ramp 1 mL/min
			2.507,
			3.794,
			5.852,
			6.830,
			7.448,
			7.886,
			8.237,
			8.529,
			8.795,
			9.044,
			9.276,
			9.490,
			9.697,
			9.903,
			10.091,
			10.280,
			10.478,
			10.675,
			10.898,
			11.139,
			11.714,
			12.486,
			13.593,
			15.207,
			17.610
		},
		{ // Thermo Trace GC Ultra 10 min ramp 1 mL/min
			2.508,
			3.794,
			6.067,
			7.499,
			8.486,
			9.249,
			9.884,
			10.459,
			10.973,
			11.463,
			11.917,
			12.346,
			12.758,
			13.153,
			13.531,
			13.883,
			14.226,
			14.561,
			14.878,
			15.196,
			15.891,
			16.767,
			17.934,
			19.599,
			22.028
		},
		{ // Thermo Trace GC Ultra 20 min ramp 1 mL/min
			2.507,
			3.793,
			6.305,
			8.431,
			10.095,
			11.467,
			12.676,
			13.774,
			14.795,
			15.747,
			16.648,
			17.506,
			18.321,
			19.093,
			19.840,
			20.552,
			21.230,
			21.891,
			22.517,
			23.126,
			24.276,
			25.384,
			26.705,
			28.490,
			31.031
		},
		{ // Thermo Trace GC Ultra 40 min ramp 1 mL/min
			2.499,
			3.793,
			6.501,
			9.553,
			12.365,
			14.885,
			17.182,
			19.308,
			21.306,
			23.176,
			24.952,
			26.633,
			28.246,
			29.773,
			31.240,
			32.647,
			33.994,
			35.289,
			36.542,
			37.743,
			40.025,
			42.162,
			44.195,
			46.255,
			49.001
		},
		{ // Thermo Trace GC Ultra 20 min ramp 2 mL/min
			0.000,
			2.713,
			4.863,
			7.374,
			9.139,
			10.553,
			11.779,
			12.876,
			13.896,
			14.848,
			15.740,
			16.598,
			17.413,
			18.185,
			18.923,
			19.635,
			20.312,
			20.973,
			21.599,
			22.208,
			23.358,
			24.439,
			25.511,
			26.858,
			28.746
		},
		{ // Thermo Trace GC Ultra 20 min ramp 3 mL/min
			0.000,
			0.000,
			3.980,
			6.747,
			8.614,
			10.070,
			11.304,
			12.400,
			13.420,
			14.363,
			15.263,
			16.112,
			16.918,
			17.689,
			18.435,
			19.138,
			19.816,
			20.467,
			21.093,
			21.702,
			22.850,
			23.931,
			24.951,
			26.092,
			27.670
		}
	};

	public static String[] StationaryPhaseArray = {
		"Agilent DB-5MS UI (0.25 \u00b5m film thickness, 0.25 mm ID)"
	};
	
	public static String[] CompoundNameArray = {
		"triethylamine",
		"n-propyl acetate",
		"toluene",
		"pyridine",
		"n-butyl acetate",
		"n-pentyl acetate",
		"pentan-2-one",
		"hexan-2-one",
		"ethylbenzene",
		"heptan-2-one",
		"n-hexyl acetate",
		"octan-2-one",
		"N,N-dimethylisobutyramide",
		"phenol",
		"linalool",
		"n-butylbenzene",
		"aniline",
		"N,N-diethylacetamide",
		"nonan-2-one",
		"acetophenone",
		"decan-2-one",
		"n-octyl acetate",
		"propiophenone",
		"naphthalene",
		"butyrophenone",
		"undecan-2-one",
		"n-decyl acetate",
		"valerophenone",
		"dodecan-2-one",
		"indole",
		"tridecan-2-one",
		"pentadecan-2-one",
		"coumarin",
		"indole-3-acetic acid ethyl ester",
		"triphenylmethane",
		"benzamide",
		"4-nitroaniline",
		"1-naphthol",
		"resorcinol",
		"hexanophenone",
		"heptanophenone",
		"octanophenone",
		"tert-butylpyridine",
		"4-methylpyridine",
		"4-ethylaniline",
		"4-butylaniline",
		"4-hexylaniline",
		"4-octylaniline",
		"4-decylaniline",
		"4-dodecylaniline",
		"octan-1-ol",
		"octanoic acid",
		"decanoic acid",
		"dextromethorphan",
		"lidocaine",
		"caffeine",
		"anthracene",
		"(1S,2R)-1-phenyl-2-(1-pyrrolidinyl)-1-propanol",
		"diphenylamine",
		"benzocaine",
		"nikethamide",
		"nicotine",
		"trihexylamine",
		"trioctylamine",
		"tridecylamine",
		"pregnenolone",
		"progesterone",
		"estrone",
		"danazol",
		"7-dehydroxycholesterol",
		"cholecalciferol"
	};
	
	public static double[][][] AlkaneIsothermalDataArray = {
		{{ 60, -0.251032867}, { 80, -0.532609425}, { 100, -0.783873919}},
		{{ 60, 0.116333239}, { 80, -0.200160794}, { 100, -0.474656467}, { 120, -0.712870565}, { 140, -0.927649422}},
		{{ 60, 0.479687648}, { 80, 0.126059911}, { 100, -0.179565633}, { 120, -0.445648607}, { 140, -0.682045793}, { 160, -0.889935415}},
		{{ 60, 0.840778188}, { 80, 0.448484821}, { 100, 0.109912792}, { 120, -0.184757438}, { 140, -0.443907697}, { 160, -0.672397316}, { 180, -0.875624186}, { 200, -1.057301045}},
		{{ 60, 1.199589162}, { 80, 0.768609728}, { 100, 0.396579552}, { 120, 0.073140892}, { 140, -0.211725784}, { 160, -0.462190912}, { 180, -0.681331256}, { 200, -0.877045857}, { 220, -1.056775327}},
		{{ 80, 1.087492445}, { 100, 0.681996921}, { 120, 0.329470923}, { 140, 0.019639001}, { 160, -0.252107982}, { 180, -0.490137363}, { 200, -0.701617477}, { 220, -0.895603810}, { 240, -1.065392962}},
		{{ 80, 1.404904323}, { 100, 0.965457023}, { 120, 0.583931137}, { 140, 0.249190035}, { 160, -0.044302310}, { 180, -0.302269068}, { 200, -0.529416278}, { 220, -0.734469865}, { 240, -0.916453949}, { 260, -1.081280305}},
		{{ 100, 1.247750658}, { 120, 0.837106893}, { 140, 0.476963659}, { 160, 0.161185431}, { 180, -0.115848477}, { 200, -0.359698034}, { 220, -0.578749254}, { 240, -0.773086534}, { 260, -0.947592895}, { 280, -1.112290469}, { 300, -1.265433116}},
		{{ 120, 1.088948193}, { 140, 0.703250424}, { 160, 0.365305413}, { 180, 0.068726786}, { 200, -0.192851944}, { 220, -0.427048799}, { 240, -0.634212020}, { 260, -0.819879104}, { 280, -0.993425880}, { 300, -1.147154009}},
		{{ 120, 1.339533793}, { 140, 0.928549119}, { 160, 0.568083522}, { 180, 0.252086343}, { 200, -0.026996179}, { 220, -0.276494167}, { 240, -0.497324641}, { 260, -0.694594729}, { 280, -0.876201281}, { 300, -1.038329227}, { 320, -1.199470754}},
		{{ 140, 1.154278720}, { 160, 0.769746663}, { 180, 0.434199871}, { 200, 0.137752471}, { 220, -0.126595939}, { 240, -0.361515623}, { 260, -0.570953557}, { 280, -0.780226240}, { 300, -0.932658218}, { 320, -1.094276075}},
		{{ 140, 1.377081080}, { 160, 0.970431142}, { 180, 0.615215981}, { 200, 0.301414741}, { 220, 0.021877083}, { 240, -0.226686943}, { 260, -0.448164314}, { 280, -0.663794087}, { 300, -0.828612771}, { 320, -0.997366062}},
		{{ 160, 1.169910127}, { 180, 0.795299220}, { 200, 0.464323986}, { 220, 0.169643195}, { 240, -0.092370124}, { 260, -0.326026060}, { 280, -0.548019039}, { 300, -0.725805095}, { 320, -0.900052242}},
		{{ 160, 1.368243021}, { 180, 0.974461234}, { 200, 0.626255342}, { 220, 0.316396415}, { 240, 0.040697443}, { 260, -0.204874476}, { 280, -0.434188184}, { 300, -0.624233946}, { 320, -0.806058055}},
		{{ 180, 1.152437239}, { 200, 0.787346178}, { 220, 0.462197085}, { 240, 0.173109333}, { 260, -0.084575231}, { 280, -0.322674943}, { 300, -0.523801794}, { 320, -0.712804181}},
		{{ 180, 1.329590927}, { 200, 0.947494043}, { 220, 0.607207245}, { 240, 0.304623594}, { 260, 0.034987555}, { 280, -0.212226937}, { 300, -0.423958500}, { 320, -0.621383622}},
		{{ 200, 1.106658022}, { 220, 0.751458089}, { 240, 0.435417136}, { 260, 0.153748733}, { 280, -0.102745151}, { 300, -0.325149040}, { 320, -0.530463973}},
		{{ 200, 1.264981560}, { 220, 0.894840798}, { 240, 0.565427700}, { 260, 0.271799053}, { 280, 0.005553451}, { 300, -0.227416704}, { 320, -0.440502820}},
		{{ 200, 1.422325668}, { 220, 1.037373053}, { 240, 0.694575181}, { 260, 0.389225909}, { 280, 0.113082637}, { 300, -0.130195480}, { 320, -0.351624005}},
		{{ 220, 1.179172645}, { 240, 0.823207700}, { 260, 0.505947581}, { 280, 0.219773760}, { 300, -0.033423755}, { 320, -0.263105972}},
		{{ 240, 1.078278181}, { 260, 0.737459487}, { 280, 0.431164381}, { 300, 0.158279953}, { 320, -0.088258042}},
		{{ 240, 1.330290761}, { 260, 0.966582945}, { 280, 0.640042575}, { 300, 0.347846573}, { 320, 0.084500166}},
		{{ 260, 1.193427853}, { 280, 0.846397263}, { 300, 0.535450309}, { 320, 0.255543389}},
		{{ 260, 1.416681012}, { 280, 1.049519111}, { 300, 0.718934185}, { 320, 0.421502349}},
		{{ 280, 1.251942749}, { 300, 0.903077192}, { 320, 0.588965730}}
	};
		
	public static double[][][] CompoundIsothermalDataArray = {
		{{ 60, -0.301829556}, { 80, -0.576766230}},
		{{ 60, -0.206844516}, { 80, -0.501394254}, { 100, -0.757633386}},
		{{ 60, 0.016202997}, { 80, -0.272600520}, { 100, -0.522961146}, { 120, -0.739703169}, { 140, -0.935729553}},
		{{ 60, -0.072574875}, { 80, -0.354917480}, { 100, -0.599349492}, { 120, -0.809625722}},
		{{ 60, 0.163575221}, { 80, -0.165758728}, { 100, -0.449587172}, { 120, -0.695861055}, { 140, -0.915804293}},
		{{ 60, 0.527592763}, { 80, 0.160903220}, { 100, -0.155219879}, { 120, -0.427933234}, { 140, -0.669716606}, { 160, -0.881090008}},
		{{ 60, -0.298110804}, { 80, -0.575798981}},
		{{ 60, 0.075795265}, { 80, -0.236196118}, { 100, -0.505199417}, { 120, -0.739703169}},
		{{ 60, 0.348528095}, { 80, 0.026623174}, { 100, -0.251776663}, { 120, -0.494505147}, { 140, -0.711440940}, { 160, -0.900793342}, { 180, -1.078731433}},
		{{ 60, 0.441626274}, { 80, 0.091929192}, { 100, -0.208941936}, { 120, -0.470452494}, { 140, -0.701816292}, { 160, -0.906325831}},
		{{ 60, 0.887019495}, { 80, 0.482561163}, { 100, 0.134533756}, { 120, -0.167124171}, { 140, -0.432879462}, { 160, -0.665947279}, { 180, -0.870583961}, { 200, -1.054797900}},
		{{ 60, 0.803701551}, { 80, 0.415860670}, { 100, 0.081973618}, { 120, -0.207759310}, { 140, -0.462705446}, { 160, -0.685592087}, { 180, -0.882436788}, { 200, -1.059818701}},
		{{ 60, 0.735126788}, { 80, 0.357101225}, { 100, 0.032378852}, { 120, -0.249597554}, { 140, -0.497696309}, { 160, -0.714440305}, { 180, -0.905346067}, { 200, -1.075239060}},
		{{ 60, 0.754953596}, { 80, 0.363925673}, { 100, 0.032149371}, { 120, -0.253022270}, { 140, -0.499933024}, { 160, -0.714440305}, { 180, -0.903540266}, { 200, -1.070037867}},
		{{ 60, 1.194834944}, { 80, 0.768267470}, { 100, 0.400355638}, { 120, 0.081196630}, { 140, -0.198903028}, { 160, -0.443032776}, { 180, -0.659216942}, { 200, -0.849742945}, { 220, -1.021351259}},
		{{ 60, 1.028701797}, { 80, 0.634391062}, { 100, 0.293996481}, { 120, -0.002647412}, { 140, -0.264010255}, { 160, -0.494734962}, { 180, -0.695607708}, { 200, -0.877045857}, { 220, -1.039883968}},
		{{ 60, 0.748938194}, { 80, 0.383296261}, { 100, 0.069251585}, { 120, -0.203065520}, { 140, -0.442386421}, { 160, -0.653557877}, { 180, -0.836850989}, { 200, -1.000880922}, { 220, -1.158945829}},
		{{ 60, 0.820059725}, { 80, 0.435566266}, { 100, 0.105783701}, { 120, -0.179584424}, { 140, -0.430124692}, { 160, -0.649431533}, { 180, -0.839953106}, { 200, -1.009789839}},
		{{ 60, 1.165295981}, { 80, 0.738518648}, { 100, 0.371070490}, { 120, 0.052377163}, { 140, -0.227398914}, { 160, -0.472998175}, { 180, -0.686766802}, { 200, -0.878706641}, { 220, -1.054321680}},
		{{ 60, 1.060281118}, { 80, 0.665699954}, { 100, 0.325108605}, { 120, 0.029226778}, { 140, -0.231407198}, { 160, -0.460194152}, { 180, -0.660244858}, { 200, -0.838981115}, { 220, -1.001405660}},
		{{ 60, 1.524400895}, { 80, 1.058922952}, { 100, 0.658191836}, { 120, 0.310405756}, { 140, 0.005402327}, { 160, -0.262092203}, { 180, -0.495272145}, { 200, -0.703170391}, { 220, -0.891059489}, { 240, -1.060485627}},
		{{ 80, 1.122472024}, { 100, 0.707819494}, { 120, 0.348810276}, { 140, 0.033861222}, { 160, -0.241544639}, { 180, -0.482783584}, { 200, -0.696556642}, { 220, -0.887712309}, { 240, -1.060485627}},
		{{ 60, 1.401185063}, { 80, 0.968661991}, { 100, 0.595496849}, { 120, 0.270723863}, { 140, -0.014662136}, { 160, -0.265048035}, { 180, -0.484609276}, { 200, -0.678981624}, { 220, -0.856685744}, { 240, -1.012052553}},
		{{ 60, 1.439284307}, { 80, 1.022930546}, { 100, 0.662510793}, { 120, 0.347841949}, { 140, 0.070125861}, { 160, -0.174368550}, { 180, -0.389419243}, { 200, -0.580708377}, { 220, -0.754840513}, { 240, -0.907785108}, { 260, -1.047295808}},
		{{ 80, 1.234842664}, { 100, 0.833042473}, { 120, 0.484024409}, { 140, 0.177860282}, { 160, -0.091364415}, { 180, -0.327344874}, { 200, -0.536167105}, { 220, -0.725204565}, { 240, -0.890949881}, { 260, -1.042650903}, { 280, -1.191471715}},
		{{ 80, 1.378178074}, { 100, 0.943237626}, { 120, 0.566382143}, { 140, 0.236352145}, { 160, -0.052535627}, { 180, -0.305893873}, { 200, -0.529416278}, { 220, -0.730972173}, { 240, -0.909505089}, { 260, -1.071296084}},
		{{ 100, 1.274797133}, { 120, 0.857365820}, { 140, 0.492142474}, { 160, 0.172934420}, { 180, -0.106549076}, { 200, -0.354194229}, { 220, -0.574678985}, { 240, -0.769326385}, { 260, -0.943896749}, { 280, -1.106961636}, { 300, -1.257945095}},
		{{ 100, 1.116443823}, { 120, 0.735360657}, { 140, 0.403925516}, { 160, 0.112862069}, { 180, -0.142811255}, { 200, -0.368343526}, { 220, -0.571450015}, { 240, -0.750999004}, { 260, -0.913688231}, { 280, -1.064126909}, { 300, -1.199026158}},
		{{ 100, 1.227109300}, { 120, 0.821068159}, { 140, 0.465544705}, { 160, 0.154141798}, { 180, -0.118795855}, { 200, -0.359194796}, { 220, -0.575489993}, { 240, -0.766837585}, { 260, -0.938410851}, { 280, -1.099089013}, { 300, -1.250583995}},
		{{ 80, 1.345289858}, { 100, 0.936143703}, { 120, 0.581987982}, { 140, 0.272394214}, { 160, 0.001378714}, { 180, -0.235870528}, { 200, -0.445117283}, { 220, -0.633597922}, { 240, -0.800360619}, { 260, -0.949452831}, { 280, -1.088809373}, { 300, -1.208859661}},
		{{ 100, 1.509163908}, { 120, 1.074193924}, { 140, 0.693068591}, { 160, 0.359208900}, { 180, 0.066994994}, { 200, -0.191140774}, { 220, -0.421888804}, { 240, -0.626060268}, { 260, -0.808952880}, { 280, -0.979382803}, { 300, -1.130231304}},
		{{ 140, 1.146458372}, { 160, 0.765897066}, { 180, 0.434282641}, { 200, 0.141103033}, { 220, -0.119720421}, { 240, -0.351864237}, { 260, -0.558654130}, { 280, -0.764298282}, { 300, -0.915456188}, { 320, -1.074532017}},
		{{ 100, 1.305659272}, { 120, 0.926408415}, { 140, 0.595756883}, { 160, 0.300684632}, { 180, 0.043219234}, { 200, -0.185372715}, { 220, -0.390029923}, { 240, -0.572125071}, { 260, -0.735883776}, { 280, -0.913565519}, { 300, -1.021958370}, { 320, -1.150827575}},
		{{ 160, 1.115956922}, { 180, 0.768195803}, { 200, 0.461293043}, { 220, 0.187938001}, { 240, -0.054909903}, { 260, -0.271094693}, { 280, -0.475468372}, { 300, -0.640939640}, { 320, -0.800887822}},
		{{ 160, 1.328432546}, { 180, 0.971204219}, { 200, 0.654054844}, { 220, 0.370833693}, { 240, 0.117876882}, { 260, -0.108367396}, { 280, -0.318776013}, { 300, -0.495965620}, { 320, -0.663286542}},
		{{ 100, 1.026900786}, { 120, 0.657920395}, { 140, 0.339110084}, { 160, 0.054844767}, { 180, -0.190489080}, { 200, -0.405705379}, { 220, -0.597876314}, { 240, -0.769326385}, { 260, -0.918868743}, { 280, -1.056987661}, { 300, -1.181659213}},
		{{ 120, 1.294214571}, { 140, 0.921340401}, { 160, 0.590338140}, { 180, 0.301928227}, { 200, 0.047644490}, { 220, -0.178848694}, { 240, -0.380976069}, { 260, -0.560933896}, { 280, -0.720832588}, { 300, -0.873680358}, { 320, -1.010800064}},
		{{ 120, 1.092989843}, { 140, 0.734707408}, { 160, 0.417515257}, { 180, 0.142775389}, { 200, -0.098562372}, { 220, -0.313606442}, { 240, -0.504725655}, { 260, -0.673356076}, { 280, -0.824875836}, { 300, -0.963562491}, { 320, -1.083161414}},
		{{ 80, 1.342980362}, { 100, 0.891739937}, { 120, 0.509114461}, { 140, 0.183423449}, { 160, -0.103753091}, { 180, -0.348991015}, { 200, -0.560767270}, { 220, -0.748468377}, { 240, -0.916453949}, { 260, -1.059130177}, { 280, -1.204534188}},
		{{ 100, 1.393921720}, { 120, 0.987003021}, { 140, 0.631995534}, { 160, 0.315849138}, { 180, 0.040328739}, { 200, -0.202846455}, { 220, -0.420222077}, { 240, -0.613676287}, { 260, -0.785329835}, { 280, -0.941594242}, { 300, -1.086933942}, { 320, -1.234736772}},
		{{ 120, 1.237006444}, { 140, 0.856504612}, { 160, 0.518297684}, { 180, 0.223060923}, { 200, -0.037648650}, { 220, -0.269739367}, { 240, -0.477121255}, { 260, -0.660710550}, { 280, -0.827650890}, { 300, -0.980859690}, { 320, -1.124431087}},
		{{ 120, 1.488604481}, { 140, 1.082303731}, { 160, 0.721701859}, { 180, 0.406751696}, { 200, 0.128333819}, { 220, -0.119333938}, { 240, -0.340558753}, { 260, -0.537212261}, { 280, -0.714350461}, { 300, -0.875214969}, { 320, -1.023481096}},
		{{ 60, 1.148781034}, { 80, 0.744758186}, { 100, 0.396256886}, { 120, 0.094211326}, { 140, -0.166181187}, { 160, -0.403033073}, { 180, -0.609313512}, { 200, -0.787711228}, { 220, -0.951020726}, { 240, -1.098718025}},
		{{ 60, 0.347186471}, { 80, 0.023642604}, { 100, -0.254680016}, { 120, -0.495270588}, { 140, -0.696132241}, { 160, -0.897373999}, { 180, -1.065899034}},
		{{ 60, 1.406331415}, { 80, 0.973013559}, { 100, 0.598960974}, { 120, 0.274535883}, { 140, -0.005972240}, { 160, -0.259156353}, { 180, -0.479149093}, { 200, -0.672317810}, { 220, -0.847042645}, { 240, -1.001275462}, { 260, -1.142272247}},
		{{ 100, 1.137592442}, { 120, 0.758580330}, { 140, 0.428909606}, { 160, 0.135173959}, { 180, -0.121654266}, { 200, -0.347643480}, { 220, -0.549436803}, { 240, -0.729980654}, { 260, -0.887969149}, { 280, -1.035228004}, { 300, -1.175886596}},
		{{ 120, 1.254698298}, { 140, 0.874546907}, { 160, 0.537007807}, { 180, 0.241493889}, { 200, -0.018875571}, { 220, -0.250896705}, { 240, -0.457207418}, { 260, -0.639762918}, { 280, -0.805373600}, { 300, -0.962092041}, { 320, -1.098181740}},
		{{ 140, 1.322738685}, { 160, 0.940631545}, { 180, 0.606087481}, { 200, 0.310814265}, { 220, 0.047532429}, { 240, -0.186401405}, { 260, -0.393410372}, { 280, -0.580363457}, { 300, -0.753191214}, { 320, -0.905841598}},
		{{ 160, 1.341396252}, { 180, 0.967936341}, { 200, 0.637970802}, { 220, 0.343948685}, { 240, 0.082142837}, { 260, -0.149743849}, { 280, -0.358829813}, { 300, -0.549578881}, { 320, -0.718714063}},
		{{ 180, 1.327570450}, { 200, 0.962950460}, { 220, 0.638064075}, { 240, 0.348725382}, { 260, 0.091750435}, { 280, -0.139351672}, { 300, -0.348690915}, { 320, -0.535766768}},
		{{ 60, 1.096697071}, { 80, 0.672228443}, { 100, 0.307527677}, { 120, -0.007022478}, { 140, -0.276470108}, { 160, -0.522955469}, { 180, -0.735778769}, { 200, -0.920818754}, { 220, -1.093313906}},
		{{ 60, 1.482419906}, { 80, 0.987730465}, { 100, 0.568495401}, { 120, 0.211001160}, { 140, -0.091868077}, { 160, -0.361428743}, { 180, -0.593160203}, { 200, -0.794507838}, { 220, -0.974769392}, { 240, -1.146552774}},
		{{ 100, 1.143615099}, { 120, 0.727373889}, { 140, 0.371050194}, { 160, 0.057675374}, { 180, -0.213022377}, { 200, -0.448611775}, { 220, -0.658253997}, { 240, -0.844038009}, { 260, -1.006220127}, { 280, -1.168094109}},
		{{ 180, 1.231914194}, { 200, 0.896805184}, { 220, 0.597481727}, { 240, 0.329973149}, { 260, 0.091919883}, { 280, -0.122839777}, { 300, -0.317830027}, { 320, -0.492002179}},
		{{ 160, 1.121524877}, { 180, 0.775972825}, { 200, 0.470399325}, { 220, 0.197371231}, { 240, -0.045851841}, { 260, -0.261726301}, { 280, -0.457101345}, { 300, -0.635119514}, { 320, -0.795245548}},
		{{ 140, 1.414302129}, { 160, 1.035876022}, { 180, 0.704287324}, { 200, 0.411150682}, { 220, 0.149685961}, { 240, -0.083275980}, { 260, -0.289767773}, { 280, -0.476500834}, { 300, -0.647669660}, { 320, -0.799066345}},
		{{ 140, 1.306083657}, { 160, 0.957503491}, { 180, 0.650998157}, { 200, 0.376900213}, { 220, 0.134267298}, { 240, -0.085056676}, { 260, -0.281283611}, { 280, -0.458288753}, { 300, -0.619498848}, { 320, -0.765341637}},
		{{ 140, 1.105521815}, { 160, 0.752433220}, { 180, 0.445768005}, { 200, 0.172780230}, { 220, -0.065977983}, { 240, -0.281830960}, { 260, -0.474616305}, { 280, -0.647507161}, { 300, -0.806159503}, { 320, -0.951609800}},
		{{ 120, 1.355913676}, { 140, 0.973854154}, { 160, 0.634265223}, { 180, 0.337679948}, { 200, 0.072905738}, { 220, -0.157217379}, { 240, -0.365789432}, { 260, -0.550872579}, { 280, -0.717143089}, { 300, -0.871036924}, { 320, -1.009861415}},
		{{ 120, 1.256498498}, { 140, 0.876316896}, { 160, 0.538742052}, { 180, 0.244559558}, { 200, -0.018416486}, { 220, -0.245469564}, { 240, -0.451573214}, { 260, -0.634317148}, { 280, -0.798813135}, { 300, -0.950979422}, { 320, -1.086969652}},
		{{ 120, 1.162757322}, { 140, 0.794239868}, { 160, 0.466717564}, { 180, 0.181485829}, { 200, -0.074152862}, { 220, -0.293975094}, { 240, -0.493777019}, { 260, -0.670019815}, { 280, -0.829847369}, { 300, -0.979313021}, { 320, -1.112523757}},
		{{ 80, 1.494686492}, { 100, 1.076102962}, { 120, 0.712217486}, { 140, 0.396252226}, { 160, 0.113039513}, { 180, -0.133597312}, { 200, -0.359556304}, { 220, -0.546879022}, { 240, -0.721620726}, { 260, -0.876791836}, { 280, -1.019794597}, { 300, -1.154916582}},
		{{ 140, 1.216739189}, { 160, 0.828236951}, { 180, 0.488428182}, { 200, 0.185875529}, { 220, -0.078965769}, { 240, -0.317355120}, { 260, -0.528391552}, { 280, -0.717143089}, { 300, -0.891276529}, { 320, -1.046706472}},
		{{ 200, 1.088786314}, { 220, 0.736920183}, { 240, 0.422626811}, { 260, 0.142101893}, { 280, -0.107992964}, { 300, -0.333427316}, { 320, -0.535519654}},
		{{ 240, 1.151468607}, { 260, 0.803940061}, { 280, 0.492638262}, { 300, 0.212621300}, { 320, -0.039083141}},
		{{ 220, 1.453129189}, { 240, 1.113943352}, { 260, 0.809756658}, { 280, 0.535920252}, { 300, 0.290559541}, { 320, 0.067721077}},
		{{ 220, 1.421906933}, { 240, 1.095516681}, { 260, 0.804244322}, { 280, 0.541140489}, { 300, 0.303749315}, { 320, 0.088747702}},
		{{ 220, 1.199118143}, { 240, 0.874820747}, { 260, 0.585584180}, { 280, 0.325165076}, { 300, 0.090337365}, { 320, -0.121270343}},
		{{ 240, 1.340964035}, { 260, 1.013707637}, { 280, 0.719215781}, { 300, 0.453512482}, { 320, 0.214084435}},
		{{ 260, 1.143672866}, { 280, 0.830625232}, { 300, 0.548409637}, { 320, 0.293652719}},
		{{ 240, 1.267701938}, { 260, 0.939144339}, { 280, 0.643495046}, { 300, 0.376847369}, { 320, 0.136373181}}
	};
}
